USE OLAP
--Raw Data
SELECT order_method_type,count(*) as number_of_sales
       ,sum(count(*)) over() as total_number_of_sales
       ,cast(count(*) as float)/cast(sum(count(*)) over() as float) as fraction
FROM sales_enriched
GROUP BY order_method_type

--Float Division
SELECT 322/7524 as integer_division
SELECT 322%7524 as left_over
SELECT cast(322 as float)/cast(7524 as float) as float_division

--Linear_pie_slices
SELECT order_method_type,number_of_sales,total_number_of_sales
       ,'|'+replicate(' ',fraction*150)+'|' as slice
FROM --Here's the data
	 (SELECT order_method_type,count(*) as number_of_sales
		   ,sum(count(*)) over() as total_number_of_sales
		   ,cast(count(*) as float)/cast(sum(count(*)) over() as float) as fraction
	 FROM sales_enriched
	 GROUP BY order_method_type) as linear_pie_data

--All we need to do now is PIVOT on this so that we have a single line of bars
WITH slices(order_method_type,slice) as
		(SELECT order_method_type,'|'+replicate(' ',fraction*150)+'|' as slice
		FROM --Here's the data
				(SELECT order_method_type,count(*) as number_of_sales
					,sum(count(*)) over() as total_number_of_sales
					,cast(count(*) as float)/cast(sum(count(*)) over() as float) as fraction
				FROM sales_enriched
				GROUP BY order_method_type) as linear_pie_data)
SELECT [Web],[E-mail],[Mail],[Telephone],[Sales visit]
FROM slices
PIVOT (min(slice) --must be aggregate function, for characters choose from min,max or count
	   FOR order_method_type IN ([Web],[E-mail],[Mail],[Telephone],[Sales visit]) 
	   ) as pivot_table

--Now to make everything neat lets change the data so that we only have one delimiter between
--Final
WITH slices(order_method_type,slice) as
        --remove extra delimiter at end of each slice
		(SELECT order_method_type,'|'+replicate(' ',fraction*150) as slice
		FROM --Here's the data
				(SELECT order_method_type,count(*) as number_of_sales
					,sum(count(*)) over() as total_number_of_sales
					,cast(count(*) as float)/cast(sum(count(*)) over() as float) as fraction
				FROM sales_enriched
				GROUP BY order_method_type) as linear_pie_data)
--Concatinate all the columns together and add extra  delimiter at end.
SELECT [Web]+[E-mail]+[Mail]+[Telephone]+[Sales visit]+'|'
       as [| Web                                                                                    | E-mail | Mail | phone | Sales visit |]
FROM slices
PIVOT (min(slice)
	   FOR order_method_type IN ([Web],[E-mail],[Mail],[Telephone],[Sales visit]) 
	   ) as pivot_table
